import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/bloc.dart';

import 'package:photogram_admin_cp/ui/components/util_widgets.dart';
import 'package:photogram_admin_cp/ui/screens/preparing_screen.dart';
import 'package:photogram_admin_cp/ui/screens/home_screen.dart';
import 'package:photogram_admin_cp/ui/screens/login_screen.dart';
import 'package:photogram_admin_cp/ui/screens/something_went_wrong_screen.dart';
import 'package:rad/widgets_async.dart';

class SplashScreen extends StatefulWidget {
  const SplashScreen({Key? key}) : super(key: key);

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen> {
  @override
  initState() {
    AuthBloc.of(context).pushEvent(AuthEventGetSession(context));
  }

  @override
  build(context) {
    return StreamBuilder<AuthState>(
      stream: AuthBloc.of(context).stream,
      builder: (context, snapshot) {
        /// If we've checked the user credentials
        if (snapshot.hasData) {
          switch (snapshot.data.runtimeType) {
            case AuthStateLoggedOut:
              return const LoginScreen();

            case AuthStateNoNetwork:
              return const SomethingWentWrongScreen();

            case AuthStatePreparing:
              return PreparingScreen(
                authedAdmin: (snapshot.data as AuthStatePreparing).authedAdmin,
              );

            case AuthStateAuthed:
              return const HomeScreen();
          }
        }

        return UtilWidgets.preloader('Confirming your status...');
      },
    );
  }
}
